//
//  GSBase.h
//  GlyphsCore
//
//  Created by Georg Seifert on 04.03.19.
//  Copyright © 2019 schriftgestaltung.de. All rights reserved.
//

#ifndef GSBase_h
#define GSBase_h

/**
 UTI of the glyphs files
 */
extern NSString *const GSDocumentTypeNative;
extern NSString *const GSDocumentTypeNativePackage;
extern NSString *const GSDocumentTypeNativeArchive;
extern NSString *const GSDocumentTypeUFO;

/**
  format of the .glyph file
 */
typedef NS_ENUM(uint8_t, GSFormatVersion) {
	/** the format in Glyphs 1 and 2*/
	GSFormatVersion1 = 1,
	/** the format in Glyphs 3 */
	GSFormatVersion3 = 3,
	/** the default format of the running app. Will change with when the format changes. Use this to always get the latest version */
	GSFormatVersionCurrent NS_SWIFT_NAME(current) = 3,
};
/**
  if the file is stored as one flat file or as a bundle with one file per glyph.
 */
typedef NS_ENUM(uint8_t, GSPackageType) {
	GSPackageFlatFile NS_SWIFT_NAME(flatFile) = 1,
	GSPackageBundle NS_SWIFT_NAME(bundle) = 2,
};

typedef NS_ENUM(uint8_t, GSSaveOptions) {
	GSSaveOptionDefault = 0,
	GSSaveOptionAutosave = 1 << 0,
	GSSaveOptionWriteLastChange = 1 << 1,
	GSSaveOptionExcludeLayers = 1 << 2,
};

typedef NS_ENUM(uint8_t, GSHandleSize) {
	GSHandleSizeSmall = 0,
	GSHandleSizeRegular = 1,
	GSHandleSizeLarge = 2,
};

extern GSHandleSize HandleSizeMode;

/**
 document notifications
 */
extern NSString *GSDocumentWasOpenedNotification;
extern NSString *GSDocumentActivateNotification;
extern NSString *GSDocumentDeactivateNotification;
extern NSString *GSDocumentWillCloseNotification;
extern NSString *GSDocumentDidCloseNotification;

extern NSString *GSUpdateInterface;
extern NSString *GSUpdateEditViewFrame;
extern NSString *GSFeaturesChanged;
extern NSString *GSInstancesChanged;

extern NSString *GSUndoNotification;

/** Used to determine how to generate the numbers features (pnum, lnum) */
typedef NS_ENUM(uint8_t, GSFigureStyles) {
	/** This is the initial state */
	GSFigureStylesNotTested = 0,
	/** There are no figures */
	GSFigureStylesNoFigures = 1,
	/** The default figures are tabular oldstyle figures */
	GSFigureStylesTosf = 2,
	/** The default figures are proportional oldstyle figures */
	GSFigureStylesOsf = 3,
	/** The default figures are tabular figures */
	GSFigureStylesTf = 4,
	/** The default figures are lining figures */
	GSFigureStylesLf = 5
};

/**
 Possible writing directions
 */
typedef NS_ENUM(uint8_t, GSWritingDirection) {
	/**
	 a default value, not used
	 */
	GSWritingDirectionBIDI NS_SWIFT_NAME(bidi) = 1,
	/**
	 Left to Right
	 */
	GSWritingDirectionLeftToRight NS_SWIFT_NAME(leftToRight) = 0, // bit one and two not set
	/**
	 Right to Left
	 */
	GSWritingDirectionRightToLeft NS_SWIFT_NAME(rightToLeft) = 1 << 1,
	/**
	 Vertical
	 */
	GSWritingDirectionVertical NS_SWIFT_NAME(vertical) = 1 << 2,
	/**
	 Line to Right
	 */
	GSWritingDirectionLineToRight NS_SWIFT_NAME(lineToRight) = 1 << 3,

	GSKerningTypeContext NS_SWIFT_NAME(kerningTypeContext) = 1 << 7,
};

#define GSWritingDirectionIsLTR(d) ((d & GSWritingDirectionRightToLeft) == 0)
#define GSWritingDirectionIsRTL(d) ((d & GSWritingDirectionRightToLeft) == GSWritingDirectionRightToLeft)
#define GSWritingDirectionIsHorizontal(d) ((d & GSWritingDirectionVertical) == 0)
#define GSWritingDirectionIsVertical(d) ((d & GSWritingDirectionVertical) == GSWritingDirectionVertical)
#define GSWritingDirectionIsLineToRight(d) ((d & GSWritingDirectionLineToRight) == GSWritingDirectionLineToRight) && ((d & GSWritingDirectionVertical) == GSWritingDirectionVertical)
#define GSWritingDirectionIsLineToLeft(d) ((d & GSWritingDirectionLineToRight) == 0) && ((d & GSWritingDirectionVertical) == GSWritingDirectionVertical)

typedef NS_ENUM(int8_t, GSComponentAlignment) {
	GSAlignmentNoAligned NS_SWIFT_NAME(none) = -2,
	GSAlignmentDisable NS_SWIFT_NAME(disabled) = -1,
	GSAlignmentDefault NS_SWIFT_NAME(default) = 0,
	GSAlignmentForce NS_SWIFT_NAME(forced) = 1,
	GSAlignmentAligned NS_SWIFT_NAME(aligned) = 2,
	GSAlignmentHorizontal NS_SWIFT_NAME(horizontal) = 3,
};

typedef NS_ENUM(int8_t, GSElementOrientation) {
	GSAlignmentLeft NS_SWIFT_NAME(left) = 0,
	GSAlignmentCenter NS_SWIFT_NAME(center) = 2,
	GSAlignmentRight NS_SWIFT_NAME(right) = 1,
	GSAlignmentNeutral NS_SWIFT_NAME(neutral) = 4,
	GSAlignmentFit NS_SWIFT_NAME(fit) = 8
};

typedef NS_ENUM(uint8_t, GSCase) {
	GSNoCase NS_SWIFT_NAME(none) = 0,
	GSUppercase NS_SWIFT_NAME(uppercase) = 1,
	GSLowercase NS_SWIFT_NAME(lowercase) = 2,
	GSSmallcaps NS_SWIFT_NAME(smallCaps) = 3,
	GSMinor NS_SWIFT_NAME(minor) = 4,
	GSOtherCase NS_SWIFT_NAME(other) = 5, // ??
};

typedef NS_ENUM(uint8_t, GSOutlineFormat) {
	GSOutlineFormatUnknown = 0,
	GSOutlineFormatCFF = 1,
	GSOutlineFormatTrueType = 2,
	GSOutlineFormatVariableTT = 3,
	GSOutlineFormatVariableCFF = 4,
	GSOutlineFormatTTCubic = 5,
	GSOutlineFormatVariableTTCubic = 6,
};

typedef NS_ENUM(uint8_t, GSLabelColors) {
	GSLabelColorRed = 0,
	GSLabelColorOrange = 1,
	GSLabelColorBroun = 2,
	GSLabelColorYellow = 3,
	GSLabelColorGreen = 4,
	GSLabelColorDarkGreen = 5,
	GSLabelColorCyan = 6,
	GSLabelColorBlue = 7,
	GSLabelColorViolet = 8,
	GSLabelColorRose = 9,
	GSLabelColorGray = 10,
	GSLabelColorBlack = 11,
	GSLabelColorMaxColor = 11,
	GSLabelColorNoColor = 0xff,
};

/// For compatibility with the future.
typedef GSLabelColors GSLabelColor;
/// For compatibility with the future.
static const GSLabelColor GSLabelColorBrown = GSLabelColorBroun;

NSString *GSNameForOutlineFormat(GSOutlineFormat outlineFormat);
NSString *GSFileExtensionForOutlineFormat(GSOutlineFormat outlineFormat);

extern NSString *const GSFontFormatPlainName;
extern NSString *const GSFontFormatOTFName;
extern NSString *const GSFontFormatTTFName;
extern NSString *const GSFontFormatTTCubicName;
extern NSString *const GSFontFormatWOFFName;
extern NSString *const GSFontFormatWOFF2Name;
// extern NSString *const GSFontFormatEOTName;

extern NSString *const GSImageExportSettingsPresets;
extern NSString *const GSImageExportSettingsActive;
extern NSString *const GSImageExportSettingsSize;
extern NSString *const GSImageExportSettingsPadding;
extern NSString *const GSImageExportSettingsFactor;
extern NSString *const GSImageExportSettingsFormat;
extern NSString *const GSImageExportSettingsName;
extern NSString *const GSImageExportSettingsFilename;
extern NSString *const GSImageExportSettingsPath;
extern NSString *const GSImageExportSettingsFormatPdf;
extern NSString *const GSImageExportSettingsFormatPng;
extern NSString *const GSImageExportSettingsFormatSvg;
extern NSString *const GSImageExportSettingsUserDataKey;
extern NSString *const GSImageExportSettingsUserDataOldKey;
extern NSString *const GSImageExportSettingsDefaultsPathKey;

typedef NSString * GSLanguageTag;

FOUNDATION_EXPORT GSLanguageTag kGSLanguageDefault;
FOUNDATION_EXPORT GSLanguageTag kGSLanguageEnglish;

typedef NSString * GSScriptTag;

FOUNDATION_EXPORT GSScriptTag const kGSScriptTagDefault;

FOUNDATION_EXPORT GSScriptTag const kGSScriptTagAdlam;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagAhom;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagAnatolianHieroglyphs;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagArabic;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagArmenian;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagAvestan;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagBalinese;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagBamum;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagBassaVah;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagBatak;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagBengali;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagBengaliV2;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagBhaiksuki;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagBopomofo;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagBrahmi;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagBraille;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagBuginese;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagBuhid;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagByzantineMusic;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagCanadianSyllabics;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagCarian;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagCaucasianAlbanian;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagChakma;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagCham;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagCherokee;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagChorasmian;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagCJKIdeographic;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagCoptic;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagCypriotSyllabary;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagCyproMinoan;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagCyrillic;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagDeseret;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagDevanagari;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagDevanagariV2;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagDivesAkuru;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagDogra;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagDuployan;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagEgyptianHieroglyphs;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagElbasan;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagElymaic;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagEthiopic;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagGeorgian;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagGlagolitic;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagGothic;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagGrantha;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagGreek;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagGujarati;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagGujaratiV2;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagGunjalaGondi;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagGurmukhi;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagGurmukhiV2;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagHangul;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagHangulJamo;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagHanifiRohingya;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagHanunoo;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagHatran;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagHebrew;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagHiragana;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagImperialAramaic;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagInscriptionalPahlavi;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagInscriptionalParthian;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagJavanese;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagKaithi;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagKannada;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagKannadaV2;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagKatakana;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagKayahLi;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagKharosthi;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagKhitanSmallScript;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagKhmer;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagKhojki;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagKhudawadi;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagLao;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagLatin;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagLepcha;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagLimbu;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagLinearA;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagLinearB;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagLisu; // (Fraser)
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagLycian;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagLydian;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagMahajani;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagMakasar;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagMalayalam;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagMalayalamV2;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagMandaicMandaean;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagManichaean;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagMarchen;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagMasaramGondi;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagMathematicalAlphanumericSymbols;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagMedefaidrin;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagMeiteiMayek; // (Meithei, Meetei)
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagMendeKikakui;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagMeroiticCursive;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagMeroiticHieroglyphs;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagMiao;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagModi;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagMongolian;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagMro;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagMultani;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagMusicalSymbols;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagMyanmar;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagMyanmarV2;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagNabataean;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagNandinagari;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagNewa;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagNewTaiLue;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagNKo;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagNueshu;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagNyiakengPuachueHmong;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagOdia; // (formerly Oriya)
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagOdiaV2; // (formerly Oriya v.2)
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagOgham;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagOlChiki;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagOldItalic;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagOldHungarian;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagOldNorthArabian;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagOldPermic;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagOldPersianCuneiform;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagOldSogdian;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagOldSouthArabian;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagOldTurkic;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagOldUyghur;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagOsage;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagOsmanya;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagPahawhHmong;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagPalmyrene;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagPauCinHau;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagPhagsPa;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagPhoenician;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagPsalterPahlavi;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagRejang;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagRunic;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagSamaritan;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagSaurashtra;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagSharada;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagShavian;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagSiddham;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagSignWriting;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagSinhala;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagSogdian;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagSoraSompeng;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagSoyombo;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagSumeroAkkadianCuneiform;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagSundanese;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagSylotiNagri;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagSyriac;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagTagalog;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagTagbanwa;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagTaiLe;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagTaiTham; // (Lanna)
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagTaiViet;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagTakri;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagTamil;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagTamilV2;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagTangsa;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagTangut;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagTelugu;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagTeluguV2;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagThaana;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagThai;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagTibetan;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagTifinagh;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagTirhuta;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagToto;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagUgariticCuneiform;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagVai;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagVithkuqi;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagWancho;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagWarangCiti;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagYezidi;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagYi;
FOUNDATION_EXPORT GSScriptTag const kGSScriptTagZanabazarSquare;

typedef NSString * GSScriptID;

FOUNDATION_EXPORT GSScriptID const kGSScriptIDAdlam;
FOUNDATION_EXPORT GSScriptID const kGSScriptIDArabic;
FOUNDATION_EXPORT GSScriptID const kGSScriptIDAvestan;
FOUNDATION_EXPORT GSScriptID const kGSScriptIDBengali;
FOUNDATION_EXPORT GSScriptID const kGSScriptIDBopomofo;
FOUNDATION_EXPORT GSScriptID const kGSScriptIDChakma;
FOUNDATION_EXPORT GSScriptID const kGSScriptIDChorasmian;
FOUNDATION_EXPORT GSScriptID const kGSScriptIDCJK;
FOUNDATION_EXPORT GSScriptID const kGSScriptIDCypriot;
FOUNDATION_EXPORT GSScriptID const kGSScriptIDDevanagari;
FOUNDATION_EXPORT GSScriptID const kGSScriptIDElymaic;
FOUNDATION_EXPORT GSScriptID const kGSScriptIDEtruscan;
FOUNDATION_EXPORT GSScriptID const kGSScriptIDGujarati;
FOUNDATION_EXPORT GSScriptID const kGSScriptIDGurmukhi;
FOUNDATION_EXPORT GSScriptID const kGSScriptIDHan;
FOUNDATION_EXPORT GSScriptID const kGSScriptIDHangul;
FOUNDATION_EXPORT GSScriptID const kGSScriptIDHebrew;
FOUNDATION_EXPORT GSScriptID const kGSScriptIDKannada;
FOUNDATION_EXPORT GSScriptID const kGSScriptIDKhmer;
FOUNDATION_EXPORT GSScriptID const kGSScriptIDLao;
FOUNDATION_EXPORT GSScriptID const kGSScriptIDLatin;
FOUNDATION_EXPORT GSScriptID const kGSScriptIDMalayalam;
FOUNDATION_EXPORT GSScriptID const kGSScriptIDMandaic;
FOUNDATION_EXPORT GSScriptID const kGSScriptIDNabataean;
FOUNDATION_EXPORT GSScriptID const kGSScriptIDNko;
FOUNDATION_EXPORT GSScriptID const kGSScriptIDOldHungarian;
FOUNDATION_EXPORT GSScriptID const kGSScriptIDOldTurkic;
FOUNDATION_EXPORT GSScriptID const kGSScriptIDOriya;
FOUNDATION_EXPORT GSScriptID const kGSScriptIDOscan;
FOUNDATION_EXPORT GSScriptID const kGSScriptIDPhoenician;
FOUNDATION_EXPORT GSScriptID const kGSScriptIDRunic;
FOUNDATION_EXPORT GSScriptID const kGSScriptIDSamaritan;
FOUNDATION_EXPORT GSScriptID const kGSScriptIDSharada;
FOUNDATION_EXPORT GSScriptID const kGSScriptIDSyriac;
FOUNDATION_EXPORT GSScriptID const kGSScriptIDTamil;
FOUNDATION_EXPORT GSScriptID const kGSScriptIDTelugu;
FOUNDATION_EXPORT GSScriptID const kGSScriptIDThaana;
FOUNDATION_EXPORT GSScriptID const kGSScriptIDThai;
FOUNDATION_EXPORT GSScriptID const kGSScriptIDTibet;
FOUNDATION_EXPORT GSScriptID const kGSScriptIDUmbrian;
FOUNDATION_EXPORT GSScriptID const kGSScriptIDKatakana;
FOUNDATION_EXPORT GSScriptID const kGSScriptIDHiragana;
FOUNDATION_EXPORT GSScriptID const kGSScriptIDMongolian;
FOUNDATION_EXPORT GSScriptID const kGSScriptIDCham;
FOUNDATION_EXPORT GSScriptID const kGSScriptIDCherokee;
FOUNDATION_EXPORT GSScriptID const kGSScriptIDGreek;
FOUNDATION_EXPORT GSScriptID const kGSScriptIDCyrillic;
FOUNDATION_EXPORT GSScriptID const kGSScriptIDLepcha;
FOUNDATION_EXPORT GSScriptID const kGSScriptIDMyanmar;

#endif /* GSBase_h */
